
libname randp 'V:\Health and Retirement Study\Grisell\HRS_data\rand\randhrs1992_2018v1';
libname data 'V:\Health and Retirement Study\Sun\side_projects\Lee_index_HRS';
proc format cntlin=randp.sasfmts;run;

%MACRO LEEINDEX(wave);

	data LEE_index_&wave. (keep=HHIDPN 	R&wave.LEEINDEX	R&wave.nmiss_LEEINDEX );
	set randp.Randhrs1992_2018v1 (keep=HHIDPN RAGENDER R&wave.AGEY_E R&wave.DIABE R&wave.CANCRE R&wave.LUNGE
											  R&wave.HEARTE R&wave.BMI R&wave.SMOKEN R&wave.BATHA R&wave.MONEYA
											  R&wave.WALKSA	R&wave.PUSHA); 

/*	1.Demographics */
	* gender;
		if ragender=1 then male_point=2;
			else if ragender=2 then male_point=0;
	*age;
		if 65=<R&wave.AGEY_E<=69 then age_point_yr&wave.=2;
		else if 70=<R&wave.AGEY_E<=74 then age_point_yr&wave.=3;
		else if 75=<R&wave.AGEY_E<=79 then age_point_yr&wave.=4;
		else if 80=<R&wave.AGEY_E<=84 then age_point_yr&wave.=5;
		else if R&wave.AGEY_E>=85 then age_point_yr&wave.=7;
		else if .<R&wave.AGEY_E<65 then age_point_yr&wave.=0;
		else if R&wave.AGEY_E=. then age_point_yr&wave.=.;

/*	2. Comorbidities and behaviors;*/
	*Diabetes mellitus;
		if R&wave.DIABE=1 then diabetes_point_yr&wave.=1;
			else if R&wave.DIABE=0 then diabetes_point_yr&wave.=0;
	*Cancer;
		if R&wave.CANCRE=1 then cancer_point_yr&wave.=2;
			else if R&wave.CANCRE=0 then cancer_point_yr&wave.=0;
	*Lung disease;
		if R&wave.LUNGE=1 then lung_disease_point_yr&wave.=2;
			else if R&wave.LUNGE=0 then lung_disease_point_yr&wave.=0;
	*Heart failure;
		if R&wave.HEARTE=1 then heart_disease_point_yr&wave.=2;
			else if R&wave.HEARTE=0 then heart_disease_point_yr&wave.=0;
	*BMI;
		if 0<R&wave.BMI<25 then BMI_point_yr&wave.=1;
			else if R&wave.BMI>=25 then BMI_point_yr&wave.=0;
	*SMOKING;
		if R&wave.SMOKEN=1 then current_smoker_point_yr&wave.=2;
			else if R&wave.SMOKEN=0 then current_smoker_point_yr&wave.=0;

/*	3. Functional measures;*/
	*Bathing;
		if R&wave.BATHA=1 then bathing_point_yr&wave.=2;
			else if R&wave.BATHA=0 then bathing_point_yr&wave.=0;
	*Managing finances;
		if R&wave.MONEYA=1 then money_mgmt_point_yr&wave.=2;
			else if R&wave.MONEYA=0 then money_mgmt_point_yr&wave.=0;
	*Walking several blocks;
		if R&wave.WALKSA=1 then walking_point_yr&wave.=2;
			else if R&wave.WALKSA=0 then walking_point_yr&wave.=0;
	*Pushing/pulling heavy objects;
		if R&wave.PUSHA =1 then heavy_object_point_yr&wave.=1;
			else if R&wave.PUSHA =0 then heavy_object_point_yr&wave.=0;

	*SUM;
		R&wave.LEEINDEX=sum(of age_point_yr&wave.,male_point,diabetes_point_yr&wave.,cancer_point_yr&wave.,
							lung_disease_point_yr&wave.,heart_disease_point_yr&wave.,BMI_point_yr&wave.,
							current_smoker_point_yr&wave.,bathing_point_yr&wave.,money_mgmt_point_yr&wave.,
							walking_point_yr&wave.,heavy_object_point_yr&wave.);								  	
		R&wave.nmiss_LEEINDEX = nmiss (of age_point_yr&wave.,male_point,diabetes_point_yr&wave.,cancer_point_yr&wave.,
							lung_disease_point_yr&wave.,heart_disease_point_yr&wave.,BMI_point_yr&wave.,
							current_smoker_point_yr&wave.,bathing_point_yr&wave.,money_mgmt_point_yr&wave.,
							walking_point_yr&wave.,heavy_object_point_yr&wave.);	
	run;

%MEND; 

%LEEINDEX(2); 
%LEEINDEX(3); 
%LEEINDEX(4); 
%LEEINDEX(5); 
%LEEINDEX(6); 
%LEEINDEX(7); 
%LEEINDEX(8); 
%LEEINDEX(9); 
%LEEINDEX(10); 
%LEEINDEX(11); 
%LEEINDEX(12); 
%LEEINDEX(13); 
%LEEINDEX(14); 

data data.hrs_leeindex_R2toR14; 
merge LEE_INDEX_2 - LEE_INDEX_13; 
by HHIDPN; 
run;

proc print data=data.hrs_leeindex_R2toR14 (obs=20); run;


